clear();
clc();
close all;                                  %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x)   -((1.38198*exp(-(3*(x.^2))/2))/(0.300014-erf(sqrt(3/2)*x)));
dYdX                = @(x,y) (-3*x*y)-(y.^2);
Anfangswert         = 0.5;                  %Anfangswert y0
obereGrenze         = 1.3;                  %Intervall obere Grenze
untereGrenze        = 1.0;                  %Intervall untere Grenze
Quantisierung       = 3;                    %Zerlegung des Intervals in Steigungsnherungen
sKommastellenDouble = '%.8f';               %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
X_INTERVALLSTUFEN(:)=untereGrenze:(obereGrenze-untereGrenze)/Quantisierung:obereGrenze;
aWERTETABELLE(1,:)=["i", ...
                    "Xi", ...
                    "Yi", ...
                    "k1", ...
                    "k2", ...
                    "k3", ...
                    "k4", ...
                    ];
                
%BERECHNUNG------------------------------------------------------------------------
h=(obereGrenze-untereGrenze)/Quantisierung;
for(i=0:1:Quantisierung)
    aWERTETABELLE(i+2,1)=i;
    aWERTETABELLE(i+2,2)=num2str(X_INTERVALLSTUFEN(i+1),sKommastellenDouble);
    if(i==0)
        aWERTETABELLE(i+2,3)=num2str(Anfangswert,sKommastellenDouble);
    else
        aWERTETABELLE(i+2,3)=num2str( ...
                                str2double(aWERTETABELLE(i+1,3))+ ...
                                ((h/6)* ...
                                    ( ...
                                        str2double(aWERTETABELLE(i+1,4))+ ...
                                        (2*str2double(aWERTETABELLE(i+1,5)))+ ...
                                        (2*str2double(aWERTETABELLE(i+1,6)))+ ...
                                        str2double(aWERTETABELLE(i+1,7)) ...
                                    ) ...
                                ) ...
                            ,sKommastellenDouble);
    end
    aWERTETABELLE(i+2,4)=num2str( ...
                            dYdX(str2double(aWERTETABELLE(i+2,2)),str2double(aWERTETABELLE(i+2,3))) ...
                         ,sKommastellenDouble);
    aWERTETABELLE(i+2,5)=num2str( ...
                            dYdX(str2double(aWERTETABELLE(i+2,2))+(h/2),str2double(aWERTETABELLE(i+2,3))+((h/2)*str2double(aWERTETABELLE(i+2,4)))) ...
                         ,sKommastellenDouble);
    aWERTETABELLE(i+2,6)=num2str( ...
                            dYdX(str2double(aWERTETABELLE(i+2,2))+(h/2),str2double(aWERTETABELLE(i+2,3))+((h/2)*str2double(aWERTETABELLE(i+2,5)))) ...
                         ,sKommastellenDouble);
    aWERTETABELLE(i+2,7)=num2str( ...
                            dYdX(str2double(aWERTETABELLE(i+2,2))+h,str2double(aWERTETABELLE(i+2,3))+(h*str2double(aWERTETABELLE(i+2,6)))) ...
                         ,sKommastellenDouble);
end
disp(aWERTETABELLE);

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE              = @(x) 0*x;
Inkrement=100;
X(:)=untereGrenze:(obereGrenze-untereGrenze)/Inkrement:obereGrenze;
plot(X,Y(X),'color','blue');
hold on;
plot(X_INTERVALLSTUFEN,str2double(aWERTETABELLE(2:end,3)),'color','red');
hold on;
plot(X,xACHSE(X),'color','black');
hold on;                                %Warten bis zur Plotausgabe
xlabel('x');
ylabel('y');
grid on;
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                  %Workspace aufrumen
%}